#include <error.h>
#include <errno.h>
#include <malloc.h>
#include <netdb.h>
#include <obstack.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/mman.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/un.h>

int connect_dataport(uint16_t port, int *fd)
{
    struct sockaddr_in      clam_data;
    struct in_addr          clam_addr;

    /* local host */
    if (!inet_aton("127.0.0.1", &clam_addr))
        return -1;

    memset(&clam_data, 0, sizeof(struct sockaddr_in));
    clam_data.sin_family    = AF_INET;
    clam_data.sin_port      = htons(port);
    memcpy(&clam_data.sin_addr, &clam_addr, sizeof(clam_addr));

    /* connect to the clam "data stream socket" */
    if ((*fd = socket(AF_INET, SOCK_STREAM, 0)) == -1)
        return -1;
    if (connect(*fd, &clam_data, sizeof(clam_data)) == -1)
        return -1;

    return 0;
}

int main( int argc, char** argv )
{
   int fd = socket(AF_UNIX, SOCK_STREAM, 0);
   uint8_t     result[64];
   
   struct sockaddr_un  clam_addr;
   clam_addr.sun_family = AF_UNIX;
   strcpy(clam_addr.sun_path, "/tmp/clamd");

   connect(fd, &clam_addr, sizeof(clam_addr));

   write(fd, "SESSION\n", 8);
   write(fd, "STREAM\n", 7);
   memset(result, '\0', 64);
   read(fd, result, sizeof(result));

   int port = strtol(result+5, NULL, 10);
   //printf("port = %d\n", port);

   int new_fd;
   int ret = connect_dataport((uint16_t)port, &new_fd);
   if( ret == -1 )
   {
      printf("connect_dataport failed.\n");
      return 0;
   }
   int file_fd = open(argv[1], O_RDONLY);

   char buf[32];
   int len;
   do {
       memset(buf,'\0',32);
       len = read(file_fd, buf, 32);
       //printf("read %d bytes: %s\n", len, buf);
       //printf("str len of buf = %d\n", strlen(buf));
       write(new_fd, buf, len);
   } while(len > 0);

   shutdown(new_fd, 2);
   close(new_fd);
   close(file_fd);
   
   memset(result, '\0', 64);
   read(fd, &result, sizeof(result));

   printf("virus : %s\n", result);
   
   write(fd, "END\n", 4);
   return 0;
}
